#### 3. 逐个字符读取字符串

因为对许多程序而言，scanf 函数和 gets 函数都有风险而且不够灵活，C 程序员经常会自己编写输入函数。通过每次读一个字符的方式读取字符串。

如果决定自己设计输入函数，那么需要考虑以下问题：

- 在开始存储字符串之前，函数应该跳过空白字符吗？
- 什么字符导致函数停止读取：换行符，任意空白字符，还是其他某种字符？需要存储这些字符还是忽略掉？
- 如果输入的字符串太长以至于无法存储，那么函数应该忽略额外的字符还是把它们留给下一次输入操作？

示例中，我们选择：不跳过空白字符，换行符结束，不存储换行符，忽略掉额外字符。

函数原型如下：

```c
int read_line(char str[], int read_num);
```

参数：str 表示存储输入的数组，read_num 表示读入字符的最大数量。

返回值：返回读入字符的个数。

使用 getchar 实现按字符读入。


